%CODEGENERATOR.GETPIBUGFIXSTRING Returns a string to fix PI-Bug in auto genereated functions.
% 
% bfixString = CGen.getPiBugfixString() Is the string with explanation comment 
% and variable declaration as described below.
% 
% Notes::
%  In some versions the symbolic toolbox writes the constant $pi$ in
%  capital letters. This way autogenerated functions might not work properly. 
%  To fix this issue a local variable is introduced:
%  PI = pi
% 
% Authors::
%  Joern Malzahn   
%  2012 RST, Technische Universitaet Dortmund, Germany
%  http://www.rst.e-technik.tu-dortmund.de   
% 
% See also CodeGenerator.constructheaderstring, CodeGenerator.replaceheader.

% Copyright (C) 1993-2012, by Peter I. Corke
% Copyright (C) 2012-2013, by Joern Malzahn
%
% This file is part of The Robotics Toolbox for Matlab (RTB).
%
% RTB is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% RTB is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.
%
% You should have received a copy of the GNU Leser General Public License
% along with RTB.  If not, see <http://www.gnu.org/licenses/>.
%
% http://www.petercorke.com
%
% The code generation module emerged during the work on a project funded by
% the German Research Foundation (DFG, BE1569/7-1). The authors gratefully 
% acknowledge the financial support.

function bfixString = getpibugfixstring(CGen)
bfixString = [];
bfixString = [bfixString, sprintf('%s\n','%% Bugfix')];
bfixString = [bfixString, sprintf('%s\n','%  In some versions the symbolic toolbox writes the constant $pi$ in')];
bfixString = [bfixString, sprintf('%s\n','%  capital letters. This way autogenerated functions might not work properly.')];
bfixString = [bfixString, sprintf('%s\n','%  To fix this issue a local variable is introduced:')];
bfixString = [bfixString, sprintf('%s\n','PI = pi;')];
bfixString = [bfixString, sprintf('%s\n','   ')];